# DITL Tools

Tools for capturing and submitting DNS traffic to DNS-OARC during DITL (Day In The Life of the Internet) data collection campaigns.

## Components

**tcpdump-split**: C utility that reads pcap data from stdin and splits it into time-based or count-based output files. Supports optional gzip compression and a "kick" command to execute after each file completes (e.g., for uploading).

**Capture Scripts** (in `scripts/`):
- `capture-tcpdump.sh` - Packet capture using tcpdump, piped through tcpdump-split
- `capture-dnscap.sh` - DNS-specific capture using dnscap (supports multiple interfaces)
- `pcap-submit-to-oarc.sh` - Uploads pcap files to OARC via SSH with MD5 verification

## Building tcpdump-split

Requires libpcap development headers.

```sh
cd tcpdump-split
./autogen.sh
./configure
make
make install
```

## Configuration

Copy `scripts/settings.sh.default` to `scripts/settings.sh` and customize:

```sh
IFACES="eth0"                      # Network interface(s) to capture
OARC_MEMBER="your-org"             # Your OARC member identifier
START_T="2024-04-09 00:00:00"      # Capture start time (UTC)
STOP_T="2024-04-11 00:00:00"       # Capture end time (UTC)
SSH_ID="/root/.ssh/oarc_id_dsa"    # SSH key for OARC upload
```

## Usage

Run capture scripts as root:

```sh
cd scripts
./capture-dnscap.sh    # or ./capture-tcpdump.sh
```

The scripts validate prerequisites (root privileges, NTP sync, network interface) before starting capture.

## License

See individual source files for license information.
